unit DataProcessing.DUnit;
{

  Delphi DUnit Test Case
  ----------------------
  This unit contains a skeleton test case class generated by the Test Case Wizard.
  Modify the generated code to correctly setup and call the methods from the unit
  being tested.

}

interface

uses
  System.SysUtils,
  TestFramework,
  DataProcessing.InjectedProperties,
  DataProcessing.Factory;

type
  // Test methods for class TDataProcessor

  TestTDataProcessor = class(TTestCase)
  strict private
    FDataProcessor: DataProcessing.InjectedProperties.TDataProcessor;
    FDataProcessorFixed: DataProcessing.Factory.TDataProcessor;
  public
    procedure SetUp; override;
    procedure TearDown; override;
  published
    procedure TestSequence;
    procedure TestSequence2;
    procedure TestOne;
    procedure TestZero;
    procedure TestZeroFixed;
    procedure TestSequenceFixed;
  end;

implementation

uses
  DataProcessing.Reader,
  DataProcessing.Reader.DUnit,
  DataProcessing.Writer,
  DataProcessing.Writer.DUnit;

procedure TestTDataProcessor.SetUp;
begin
  FDataProcessor := DataProcessing.InjectedProperties.TDataProcessor.Create;
  FDataProcessorFixed := DataProcessing.Factory.TDataProcessor.Create;
end;

procedure TestTDataProcessor.TearDown;
begin
  FreeAndNil(FDataProcessor);
  FreeAndNil(FDataProcessorFixed);
end;

procedure TestTDataProcessor.TestSequence;
var
  writer: ITestWriter;
begin
  writer := TTestWriter.Create;

  FDataProcessor.Reader := TTestReader.Create([1, 1, 2, 2]);
  FDataProcessor.Writer := writer as IWriter;
  FDataProcessor.ProcessData;

  CheckEquals(4, writer.Count);
  CheckEquals(6, writer.Sum);
  CheckEquals(double(1.5), double(writer.Average));
end;

procedure TestTDataProcessor.TestSequence2;
var
  writer: ITestWriter;
begin
  writer := TTestWriter.Create;

  FDataProcessor.Reader := TTestReader.Create([1, 2, 3, 4]);
  FDataProcessor.Writer := writer as IWriter;
  FDataProcessor.ProcessData;

  CheckEquals(4, writer.Count);
  CheckEquals(10, writer.Sum);
  CheckEquals(double(2.5), double(writer.Average));
end;

procedure TestTDataProcessor.TestOne;
var
  writer: ITestWriter;
begin
  writer := TTestWriter.Create;

  FDataProcessor.Reader := TTestReader.Create([1]);
  FDataProcessor.Writer := writer as IWriter;
  FDataProcessor.ProcessData;

  CheckEquals(1, writer.Count);
  CheckEquals(1, writer.Sum);
  CheckEquals(double(1), double(writer.Average));
end;

procedure TestTDataProcessor.TestZero;
var
  writer: ITestWriter;
begin
  writer := TTestWriter.Create;

  FDataProcessor.Reader := TTestReader.Create([]);
  FDataProcessor.Writer := writer as IWriter;
  FDataProcessor.ProcessData;

  CheckEquals(0, writer.Count);
  CheckEquals(0, writer.Sum);
  CheckEquals(double(0), double(writer.Average));
end;

procedure TestTDataProcessor.TestZeroFixed;
var
  writer: ITestWriter;
begin
  writer := TTestWriter.Create;

  FDataProcessorFixed.Reader := TTestReader.Create([]);
  FDataProcessorFixed.WriterFactory :=
    function: IWriter
    begin
      Result := writer as IWriter;
    end;
  FDataProcessorFixed.ProcessData;

  CheckFalse(writer.WasCalled);
end;

procedure TestTDataProcessor.TestSequenceFixed;
var
  writer: ITestWriter;
begin
  writer := TTestWriter.Create;

  FDataProcessorFixed.Reader := TTestReader.Create([1, 1, 2, 2]);
  FDataProcessorFixed.WriterFactory :=
    function: IWriter
    begin
      Result := writer as IWriter;
    end;
  FDataProcessorFixed.ProcessData;

  CheckTrue(writer.WasCalled);
  CheckEquals(4, writer.Count);
  CheckEquals(6, writer.Sum);
  CheckEquals(double(1.5), double(writer.Average));
end;

initialization
  // Register any test cases with the test runner
  RegisterTest(TestTDataProcessor.Suite);
end.

